/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client.pi;

import com.ibm.hsc.common.util.PIHscUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

class BusNumberSlot {
    static String CEC_CIM_CLASS = "IBMHSC_ComputerSystem";
    static String CREATION_CLASS_NAME = "CreationClassName";
    static Vector inParams;
    static Vector outParams;

    BusNumberSlot() {
    }

    static String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    static CIMObjectPath getCOP(String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(CEC_CIM_CLASS, "root/ibmhscS1_0");
        cIMObjectPath.addKey("Name", new CIMValue((Object)string));
        cIMObjectPath.addKey(CREATION_CLASS_NAME, new CIMValue((Object)CEC_CIM_CLASS));
        return cIMObjectPath;
    }

    static Vector getIOHubs(String string) {
        Object object;
        Vector vector = new Vector();
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Vector<UnsignedInt32> vector3 = new Vector<UnsignedInt32>();
        try {
            object = PIHscUtil.invokeCIMMethod(BusNumberSlot.getHostName(), BusNumberSlot.getCOP(string), "GetIOHubs", vector, vector2);
        }
        catch (Exception exception) {
            System.out.println("Could not invoke GetIOHubs method.");
            exception.printStackTrace();
        }
        vector2.add(new CIMProperty("DRCIndex", new CIMValue(new Vector(), new CIMDataType(25))));
        vector2.add(new CIMProperty("HubType", new CIMValue(new Vector(), new CIMDataType(21))));
        object = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
        Vector vector4 = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
        Enumeration enumeration = ((Vector)object).elements();
        Enumeration enumeration2 = vector4.elements();
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt32 unsignedInt32 = null;
        int n = -1;
        int n2 = -1;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            unsignedInt8 = (UnsignedInt8)enumeration.nextElement();
            unsignedInt32 = (UnsignedInt32)enumeration2.nextElement();
            n = unsignedInt8.intValue();
            n2 = unsignedInt32.intValue();
            if (n == 0) {
                vector3.add(unsignedInt32);
                continue;
            }
            if (n == 1) {
                System.out.println("HubType of Infiniband found on Managed System: " + string);
                System.out.println("Infiniband DRCIndex value = " + n2);
                System.out.println("We do not need this HubType at the moment.");
                continue;
            }
            if (n == 2) {
                System.out.println("HubType of SMA found on Managed System: " + string);
                System.out.println("SMA DRCIndex value = " + n2);
                System.out.println("We do not need this HubType at the moment.");
                continue;
            }
            if (n == 255) {
                System.out.println("Error:BED1-0055:Unknown HubType on Managed System:" + string);
                System.exit(1);
                continue;
            }
            System.out.println("Error:BED1-0056:Unable to locate any I/O Hubs this system:" + string);
            System.exit(1);
        }
        return vector3;
    }

    static Vector getRioBuses(UnsignedInt32 unsignedInt32, String string, int n) {
        Object object;
        inParams = new Vector();
        CIMValue cIMValue = new CIMValue((Object)unsignedInt32, new CIMDataType(5));
        inParams.add(new CIMProperty("HubDRCIndex", cIMValue));
        outParams = new Vector();
        Vector<UnsignedInt32> vector = new Vector<UnsignedInt32>();
        try {
            object = PIHscUtil.invokeCIMMethod(BusNumberSlot.getHostName(), BusNumberSlot.getCOP(string), "GetRioBuses", inParams, outParams);
        }
        catch (Exception exception) {
            System.out.println("Could not invoke GetRioBuses method.");
            exception.printStackTrace();
        }
        object = (Vector)((CIMProperty)outParams.elementAt(0)).getValue().getValue();
        Vector vector2 = (Vector)((CIMProperty)outParams.elementAt(1)).getValue().getValue();
        Enumeration enumeration = ((Vector)object).elements();
        Enumeration enumeration2 = vector2.elements();
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt32 unsignedInt322 = null;
        int n2 = -1;
        int n3 = -1;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            unsignedInt8 = (UnsignedInt8)enumeration2.nextElement();
            unsignedInt322 = (UnsignedInt32)enumeration.nextElement();
            n2 = unsignedInt8.intValue();
            n3 = unsignedInt322.intValue();
            if (n2 == 0) {
                vector.add(unsignedInt322);
                continue;
            }
            if (n2 == 1) {
                vector.add(unsignedInt322);
                continue;
            }
            System.out.println("Unknown Bus Type");
            System.exit(1);
        }
        return vector;
    }

    static Vector getRioNodes(UnsignedInt32 unsignedInt32, String string) {
        int n;
        Object object;
        inParams = new Vector();
        outParams = new Vector();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        CIMValue cIMValue = new CIMValue((Object)unsignedInt32);
        inParams.add(new CIMProperty("BusNumber", cIMValue));
        try {
            object = PIHscUtil.invokeCIMMethod(BusNumberSlot.getHostName(), BusNumberSlot.getCOP(string), "GetRioTopology", inParams, outParams);
        }
        catch (Exception exception) {
            System.out.println("Could not invoke GetRioBuses method.");
            exception.printStackTrace();
        }
        object = (Vector)((CIMProperty)outParams.elementAt(2)).getValue().getValue();
        Vector vector3 = (Vector)((CIMProperty)outParams.elementAt(3)).getValue().getValue();
        Vector vector4 = (Vector)((CIMProperty)outParams.elementAt(21)).getValue().getValue();
        Vector vector5 = (Vector)((CIMProperty)outParams.elementAt(7)).getValue().getValue();
        Enumeration enumeration = ((Vector)object).elements();
        Enumeration enumeration2 = vector3.elements();
        Enumeration enumeration3 = vector4.elements();
        Enumeration enumeration4 = vector5.elements();
        UnsignedInt8 unsignedInt8 = null;
        Object var14_15 = null;
        UnsignedInt8 unsignedInt82 = null;
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            unsignedInt8 = (UnsignedInt8)enumeration.nextElement();
            n = unsignedInt8.intValue();
            unsignedInt82 = (UnsignedInt8)enumeration4.nextElement();
            int n2 = unsignedInt82.intValue();
            string2 = (String)enumeration3.nextElement();
            if (string2 == null || !string2.startsWith("U7311.D11") && !string2.startsWith("U1300.001")) continue;
            System.out.println(string2 + "," + unsignedInt32 + "," + "External");
        }
        n = unsignedInt82.intValue();
        if (string2 != null && n == 128 || n == 1 && string2.startsWith("U7879")) {
            System.out.println(string2 + "," + unsignedInt32 + "," + "Internal");
        }
        return vector;
    }
}

